/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.balm.api.BalmHooks;
import net.blay09.mods.balm.api.BalmRegistries;
import net.blay09.mods.balm.api.EmptyLoadContext;
import net.blay09.mods.balm.api.block.BalmBlockEntities;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.balm.api.capability.BalmCapabilities;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.balm.api.compat.BalmModSupport;
import net.blay09.mods.balm.api.component.BalmComponents;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.balm.api.loot.BalmLootTables;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.balm.api.network.BalmNetworking;
import net.blay09.mods.balm.api.particle.BalmParticles;
import net.blay09.mods.balm.api.permission.BalmPermissions;
import net.blay09.mods.balm.api.recipe.BalmRecipes;
import net.blay09.mods.balm.api.resources.BalmResources;
import net.blay09.mods.balm.api.resources.ModResource;
import net.blay09.mods.balm.api.resources.ModResourceVisitor;
import net.blay09.mods.balm.api.resources.PathModResource;
import net.blay09.mods.balm.api.sound.BalmSounds;
import net.blay09.mods.balm.api.stats.BalmStats;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.common.BalmLoadContexts;
import net.blay09.mods.balm.common.CommonBalmLootTables;
import net.blay09.mods.balm.common.CommonBalmRuntime;
import net.blay09.mods.balm.common.LegacyNamespaceResolver;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.common.permission.CommonBalmPermissions;
import net.blay09.mods.balm.fabric.FabricBalmHooks;
import net.blay09.mods.balm.fabric.FabricBalmRegistries;
import net.blay09.mods.balm.fabric.block.FabricBalmBlocks;
import net.blay09.mods.balm.fabric.block.entity.FabricBalmBlockEntities;
import net.blay09.mods.balm.fabric.capability.FabricBalmCapabilities;
import net.blay09.mods.balm.fabric.command.FabricBalmCommands;
import net.blay09.mods.balm.fabric.compat.FabricBalmModSupport;
import net.blay09.mods.balm.fabric.component.FabricBalmComponents;
import net.blay09.mods.balm.fabric.config.FabricBalmConfig;
import net.blay09.mods.balm.fabric.entity.FabricBalmEntities;
import net.blay09.mods.balm.fabric.event.FabricBalmCommonEvents;
import net.blay09.mods.balm.fabric.event.FabricBalmEvents;
import net.blay09.mods.balm.fabric.item.FabricBalmItems;
import net.blay09.mods.balm.fabric.menu.FabricBalmMenus;
import net.blay09.mods.balm.fabric.network.FabricBalmNetworking;
import net.blay09.mods.balm.fabric.particle.FabricBalmParticles;
import net.blay09.mods.balm.fabric.recipe.FabricBalmRecipes;
import net.blay09.mods.balm.fabric.resources.FabricBalmResources;
import net.blay09.mods.balm.fabric.sound.FabricBalmSounds;
import net.blay09.mods.balm.fabric.stats.FabricBalmStats;
import net.blay09.mods.balm.fabric.world.FabricBalmWorldGen;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_7225;

public class FabricBalmRuntime
extends CommonBalmRuntime<EmptyLoadContext> {
    private final NamespaceResolver legacyNamespaceResolver = new LegacyNamespaceResolver(() -> {
        throw new UnsupportedOperationException("No default namespace available");
    });
    private final BalmWorldGen worldGen = new FabricBalmWorldGen();
    private final BalmItems items = new FabricBalmItems(this.legacyNamespaceResolver);
    private final BalmBlocks blocks = new FabricBalmBlocks(this.legacyNamespaceResolver, this.items);
    private final BalmBlockEntities blockEntities = new FabricBalmBlockEntities();
    private final FabricBalmEvents events = new FabricBalmEvents();
    private final BalmMenus menus = new FabricBalmMenus();
    private final BalmNetworking networking = new FabricBalmNetworking();
    private final BalmConfig config = new FabricBalmConfig();
    private final BalmHooks hooks = new FabricBalmHooks();
    private final BalmRegistries registries = new FabricBalmRegistries();
    private final BalmSounds sounds = new FabricBalmSounds();
    private final BalmEntities entities = new FabricBalmEntities();
    private final BalmCapabilities capabilities = new FabricBalmCapabilities();
    private final BalmCommands commands = new FabricBalmCommands();
    private final BalmLootTables lootTables = new CommonBalmLootTables();
    private final BalmStats stats = new FabricBalmStats();
    private final BalmRecipes recipes = new FabricBalmRecipes();
    private final BalmComponents components = new FabricBalmComponents();
    private final BalmModSupport modSupport = new FabricBalmModSupport(this);
    private final BalmParticles particles = new FabricBalmParticles();
    private final Supplier<BalmPermissions> permissions = this.modProxy().with("fabric-permissions-api-v0", "net.blay09.mods.balm.fabric.compat.FabricPermissionsAPIIntegration").withFallback(new CommonBalmPermissions()).buildLazily();
    private final BalmResources resources = new FabricBalmResources();

    public FabricBalmRuntime() {
        FabricBalmCommonEvents.registerEvents(this.events);
    }

    @Override
    public BalmConfig getConfig() {
        return this.config;
    }

    @Override
    public BalmEvents getEvents() {
        return this.events;
    }

    @Override
    public BalmWorldGen getWorldGen() {
        return this.worldGen;
    }

    @Override
    public BalmBlocks getBlocks() {
        return this.blocks;
    }

    @Override
    public BalmBlockEntities getBlockEntities() {
        return this.blockEntities;
    }

    @Override
    public BalmItems getItems() {
        return this.items;
    }

    @Override
    public BalmMenus getMenus() {
        return this.menus;
    }

    @Override
    public BalmNetworking getNetworking() {
        return this.networking;
    }

    @Override
    public BalmHooks getHooks() {
        return this.hooks;
    }

    @Override
    public BalmRegistries getRegistries() {
        return this.registries;
    }

    @Override
    public BalmSounds getSounds() {
        return this.sounds;
    }

    @Override
    public BalmEntities getEntities() {
        return this.entities;
    }

    @Override
    public BalmCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public BalmCommands getCommands() {
        return this.commands;
    }

    @Override
    public BalmLootTables getLootTables() {
        return this.lootTables;
    }

    @Override
    public BalmStats getStats() {
        return this.stats;
    }

    @Override
    public BalmRecipes getRecipes() {
        return this.recipes;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public String getModName(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(it -> it.getMetadata().getName()).orElse(modId);
    }

    @Override
    public void initializeMod(String modId, EmptyLoadContext context, Runnable initializer) {
        BalmLoadContexts.register(modId, context);
        initializer.run();
    }

    @Override
    public void addServerReloadListener(class_2960 identifier, final Function<class_7225.class_7874, class_3302> factory) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(identifier, providers -> new IdentifiableResourceReloadListener(){
            private final class_3302 listener;
            final /* synthetic */ class_7225.class_7874 val$providers;
            final /* synthetic */ class_2960 val$identifier;
            {
                this.val$providers = class_78742;
                this.val$identifier = class_29602;
                this.listener = (class_3302)factory.apply(this.val$providers);
            }

            public class_2960 getFabricId() {
                return this.val$identifier;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_11558 sharedState, Executor executor, class_3302.class_4045 preparationBarrier, Executor executor2) {
                return this.listener.method_25931(sharedState, executor, preparationBarrier, executor2);
            }
        });
    }

    @Override
    public void addServerReloadListener(final class_2960 identifier, final Consumer<class_3300> reloadListener) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 resourceManager) {
                reloadListener.accept(resourceManager);
            }

            public class_2960 getFabricId() {
                return identifier;
            }
        });
    }

    @Override
    public BalmComponents getComponents() {
        return this.components;
    }

    @Override
    public BalmModSupport getModSupport() {
        return this.modSupport;
    }

    @Override
    public BalmParticles getParticles() {
        return this.particles;
    }

    @Override
    public BalmPermissions getPermissions() {
        return this.permissions.get();
    }

    @Override
    public String getPlatform() {
        return "fabric";
    }

    @Override
    public BalmResources getResources() {
        return this.resources;
    }

    @Override
    public BalmEnvironment getEnvironment() {
        return switch (FabricLoader.getInstance().getEnvironmentType()) {
            default -> throw new MatchException(null, null);
            case EnvType.CLIENT -> BalmEnvironment.CLIENT;
            case EnvType.SERVER -> BalmEnvironment.DEDICATED_SERVER;
        };
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public List<String> getLoadedPrimaryModIds() {
        return FabricLoader.getInstance().getAllMods().stream().map(it -> it.getMetadata().getId()).toList();
    }

    @Override
    public void visitModResources(String modId, String path, ModResourceVisitor visitor) {
        FabricLoader.getInstance().getModContainer(modId).flatMap(modContainer -> modContainer.findPath(path)).ifPresent(rootPath -> {
            try (Stream<Path> walker = Files.walk(rootPath, new FileVisitOption[0]);){
                walker.forEach(childPath -> visitor.visit(new PathModResource((Path)childPath)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Optional<ModResource> lookupModResource(String modId, String path) {
        return FabricLoader.getInstance().getModContainer(modId).flatMap(modContainer -> modContainer.findPath(path)).map(PathModResource::new);
    }
}

